%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   Electric potential due to a charged ring


clear all;
close all;

Ql = input('Enter the uniform charge per unit length of the ring in C per meter: ');
a = input('Enter the ring radius in meters: ');
EPS0 = 8.8542*10^(-12);

dz = 0.01*a;
z = 20*dz:dz:10*a;
Qtot = Ql*2*pi*a;
Vz = Qtot./(4*pi*EPS0*sqrt(z.^2 + a^2));

% z>>a 
V = Qtot./(4*pi*EPS0*z);

plot(z, Vz), hold on;
xlabel ('z (m)'), ylabel ('Potential (V)');
title ('Scalar potential comparison');
plot (z, V, 'r');
legend ('Potential due to charged ring','Potential due to point charge',1);
hold off;